#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>

using namespace std;

const int MAXN = 2005, MAXM = 200 * 1000 + 5;
int p[MAXN], q[MAXN];
char used[MAXN], onc0[MAXN], onc1[MAXN];
vector<int> g[MAXN], path;

bool dfs(int v) {
    used[v] = 1;
    path.push_back(v);
    for(size_t i = 0; i < g[v].size(); i++)
        if(g[v][i] != p[v]) {
            if(used[q[g[v][i]]] == 1) {
                for(int j = (int)path.size() - 1; j >= 0 && path[j] != q[g[v][i]]; j--) {
                    onc0[path[j]] = true;
                    onc1[p[path[j]]] = true;
                }
                onc0[q[g[v][i]]] = true;
                onc1[g[v][i]] = true;
            }
            else if(used[q[g[v][i]]] == 0)
                dfs(q[g[v][i]]);
        }
    used[v] = 2;
    path.pop_back();
}

int main() {
    ios_base::sync_with_stdio(false);
    int n;
    cin >> n;
    for(int i = 0; i < n; i++) {
        int k;
        cin >> k;
        g[i].resize(k);
        for(int j = 0; j < k; j++) {
            cin >> g[i][j];
            g[i][j]--;
        }
    }
    for(int i = 0; i < n; i++) {
        cin >> p[i];
        p[i]--;
        q[p[i]] = i;
    }
    for(int i = 0; i < n; i++)
        if(!used[i])
            dfs(i);
    for(int i = 0; i < n; i++) {
        bool b = false;
        for(size_t j = 0; j < g[i].size(); j++)
            if(g[i][j] != p[i] && onc0[i] && onc1[g[i][j]]) {
                cout << 2 << ' ' << p[i] + 1 << ' ' << g[i][j] + 1 << '\n';
                b = true;
                break;
            }
        if(!b) {
            cout << 1 << ' ' << p[i] + 1 << '\n';
        }
    }
    return 0;
}
